% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_host.R
\name{remove_matches}
\alias{remove_matches}
\title{Helper function to remove reads matched to filter libraries}
\usage{
remove_matches(
  reads_bam,
  read_names,
  output,
  YS,
  threads,
  aligner,
  make_bam,
  quiet
)
}
\arguments{
\item{reads_bam}{The name of a merged, sorted .bam file that has previously
been aligned to a reference library. Likely, the output from running an
instance of \code{align_target()}.}

\item{read_names}{A \code{list} of target query names from \code{reads_bam}
that have also aligned to a filter reference library. Each \code{list}
element should be a vector of read names.}

\item{output}{The name of the .bam or .csv.gz file that to which the filtered
alignments will be written.}

\item{YS}{yieldSize, an integer. The number of alignments to be read in from
the bam file at once for chunked functions. Default is 100000.}

\item{threads}{The number of threads to be used in filtering the bam file.
Default is 1.}

\item{aligner}{The aligner which was used to create the bam file.}

\item{make_bam}{Logical, whether to also output a bam file with host reads
filtered out. A .csv.gz file will be created instead if \code{FALSE}.
Creating a bam file is costly on resources over creating a compressed
csv file with only relevant information, so default is \code{FALSE}.}

\item{quiet}{Turns off most messages. Default is \code{TRUE}.}
}
\value{
Depending on input \code{make_bam}, either the name of a filtered,
  sorted .bam file written to the user's current working directory, or an RDS
  file containing a data frame of only requisite information to run
  \code{metascope_id()}.
}
\description{
Using the \code{filter_host()} function, we align our sequencing sample to
all filter libraries of interest. The \code{remove_matches()} function allows
for removal of any target reads that are also aligned to filter libraries.
}
\details{
This function is not intended for direct use.
}
