## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(warning = FALSE,
                      message = FALSE)

## ----message=FALSE, warning=FALSE---------------------------------------------
library(ProteinGymR)
library(ComplexHeatmap)
library(stringr)
library(dplyr)
library(ggplot2)
library(ggExtra)

## ----ACE default heatmap, fig.wide = TRUE-------------------------------------
ace2_dms <- plot_dms_heatmap(
    assay_name = "ACE2_HUMAN_Chan_2020",
    start_pos = 1, 
    end_pos = 100)

ace2_dms

## ----SHOC2 heatmap, fig.wide = TRUE-------------------------------------------
shoc2_dms <- plot_dms_heatmap(assay_name = "SHOC2_HUMAN_Kwon_2022", 
    start_pos = 10,
    end_pos = 60,
    cluster_rows = TRUE)

shoc2_dms

## ----fig.width = 9, fig.height = 7--------------------------------------------
ace2_model <- plot_zeroshot_heatmap(
    assay_name = "ACE2_HUMAN_Chan_2020", 
    model = "GEMME",
    start_pos = 1,
    end_pos = 100)

ComplexHeatmap::draw(ace2_dms %v% ace2_model)

## ----fig.wide = TRUE----------------------------------------------------------
plot_structure(assay_name = "ACE2_HUMAN_Chan_2020")

## ----fig.wide = TRUE----------------------------------------------------------
plot_structure(assay_name = "ACE2_HUMAN_Chan_2020", 
    data_scores = "Kermut",
    full_structure = TRUE)

## ----fig.wide = TRUE----------------------------------------------------------
plot_structure(assay_name = "C6KNH7_9INFA_Lee_2018", 
    aggregate_fun = min)

## ----warning = FALSE, fig.wide = TRUE-----------------------------------------
dms_corr_plot(uniprotId = "Q9NV35")

## ----fig.wide = TRUE----------------------------------------------------------
model_corr_plot(
     uniprotId = "P04637",
     model1 = "Kermut",
     model2 = "ProteinNPT"
)

## -----------------------------------------------------------------------------
sessionInfo()

