\name{score}
\alias{score}
\title{Computes the score function of gene expression vectors}
\description{The score function measures how well an explanatory
  variable discriminates a given binary response. It can be interpreted
  as counting for each observation having response zero, the number of
  individuals of response class one that have smaller expression values,
  and summing up these quantities and is equivalent to the test
  statistic of the Wilcoxon test.} 
\usage{score(x, resp)}
\arguments{
  \item{x}{A numerical vector, containing the value of the explanatory
    variable for all instances.}
  \item{resp}{Vector, containing the class labels of the instances which
    have to coded by 0 and 1.}}
\value{An integer, the score of that particular explanatory variable.}
\references{See "Boosting for Tumor Classification with Gene
  Expression Data", Dettling and Buhlmann (2002), available on the web
  page http://stat.ethz.ch/~dettling/boosting.html}
\author{Marcel Dettling}
\examples{
data(leukemia)

plot(leukemia.x[,69],leukemia.y)
title(paste("Score = ", score(leukemia.x[,69], leukemia.y)))}

\keyword{htest}
