\name{summarize}
\alias{summarize}
\title{Summarizes the output of crossval() and logitboost() by printing
  and plotting}
\description{Prints and plots error-rates for optimal, fixed and (optionally)
  estimated stopping times when predicting a test set with logitboost(),
  or when running v-fold cross validation via crossval().}
\usage{summarize(boost.out, resp, mout=100, grafik=T)}
\arguments{
  \item{boost.out}{A list, obtained as output of either logitboost() or
    crossval()} 
  \item{resp}{A numerical vector, containing the true response labels of
    the K classes as consecutive integers from 0 to (K-1).}
  \item{mout}{An integer, giving the number of iterations of the
    boosting procedure, for which the error rate should be printed. The
    default value mout=100 is usually a good choice for gene expression
    data, which can well be inspected visually by the boosting error
    curve.}
  \item{grafik}{Logical flag, indicates whether the boosting error curve
    should be plotted or not. The default is TRUE.}}
\value{Prints and plots the error-rates from the LogitBoost procedure.}
\references{See "Boosting for Tumor Classification with Gene
  Expression Data", Dettling and Buhlmann (2002), available on the web
  page http://stat.ethz.ch/~dettling/boosting.html}
\author{Marcel Dettling}
\examples{
data(leukemia)

## An example without stopping parameter estimation
fit <- crossval(leukemia.x,leukemia.y,v=5,mfinal=100,presel=75,verbose=TRUE)
summarize(fit, leukemia.y, grafik=FALSE)
summarize(fit, leukemia.y, mout=57)}
\keyword{classif}
