
           /************************************************/
           /*                                              */
           /*         C-code for the score function        */
           /*         -----------------------------        */
           /*                                              */
           /*       Marcel Dettling, 25. Februar 2002      */
           /*                                              */
           /************************************************/


/*  Laden des Standard-Packages */
#include <stdio.h>

/*  <R.h> ist ntig fr R_alloc und die Sortieralgorithmen */
#include <R.h>

/*  Diese Funktion berechnet den Score eines Vektors der Lnge n */
int score(double x[], double sec_x[], int response[], int sec_response[], int n)
{
  /*  Variablendefinition */
  int    i;
  int    j;
  int    score_value   = 0;

  /*  Berechnung des Score */
  for (i=0; i<n; i++)
  {
    sec_response[i] = response[i];
    sec_x[i]        = x[i];
  }
  rsort_with_index(sec_x, sec_response, n);
  for (i=0; i<=n-1; ++i)
  {
    for (j=i; j<=n-1; ++j)
      {
	score_value = (score_value + (sec_response[i]>sec_response[j])); 
      }; 
  }

  /*  Rckgabewert */
  return(score_value);
}


/*  Der Wrapper fr die Score-Berechnung aus R */
void R_score(double *x_ptr, int *response_ptr, int *n_ptr, double *result_ptr)
{
  /*  Vektorendefinition */
  int    *sec_response        = (int *) R_alloc(*n_ptr, sizeof(int));
  double *sec_x               = (double *) R_alloc(*n_ptr, sizeof(double));

  /*  Funktionsaufruf */
  *result_ptr = score(x_ptr, sec_x, response_ptr, sec_response, *n_ptr);
}
