summarize <- function(boost.out, resp, mout=100, grafik=TRUE)
  {
    ## Binary version
    if ((K <- nlevels(as.factor(resp)))==2)
      {
        mcra <- apply(((boost.out$probs>0.5)*1)!=resp, 2, mean)
        mini <- which.min(mcra)
        mcrs <- round(min(mcra), 4)
        print(paste("Minimal mcr:  ",mcrs, "achieved after",
                    mini, "boosting step(s)"))
        mcrf <- round(mean(((boost.out$probs[,mout]>0.5)*1)!=resp),4)
        print(paste("Fixed mcr:    ",mcrf,"achieved after", mout,
                    "boosting step(s)"))
        if (length(boost.out)==2)
          {
            c.likeli     <- numeric(length(resp))
            m.likeli     <- apply(boost.out$loglikeli, 1, which.max)
            for (i in 1:length(resp))
              {
                classification <- ((boost.out$probs>0.5)*1)
                c.likeli[i]    <- classification[i, m.likeli[i]]
              }            
            mcrl  <- round(mean((c.likeli!=resp)),4)
            print(paste("Estimated mcr:", mcrl, "achieved after",
                  round(mean(m.likeli),2), "boosting step(s)"))
          }
        if (grafik)
          {
            xax <- "Boosting steps"
            yax <- "Error rate"
            ttl <- "LogitBoost"
            plot(mcra, xlab=xax, ylab=yax, main=ttl, type="l")
          }
      }
    
    ## Multiclass version
    if ((K <- nlevels(as.factor(resp)))>2)
      {
        clas <- apply(boost.out$probs, c(1,2), which.max)-1
        mcra <- apply(clas!=resp, 2, mean)
        mini <- which.min(mcra)
        mcrs <- round(min(mcra), 4)
        print(paste("Minimal mcr:  ",mcrs, "achieved after",
                    mini, "boosting step(s)"))
        mcrf <- round(mean(clas[,mout]!=resp),4)
        print(paste("Fixed mcr:    ",mcrf, "achieved after", mout,
                    "boosting step(s)"))
        if (length(boost.out)==2)
          {
            stops <- apply(boost.out$loglikeli,c(1,3),which.max)
            fprob <- matrix(0, length(resp), K)
            for (j in 1:K)
              {
                for (i in 1:length(resp))
                  {
                    fprob[i,j] <- boost.out$probs[i,stops[i,j],j]
                  }
              }
            class <- apply(fprob, 1, which.max)-1
            mcrl  <- round(mean(class!=resp),4)
            mlik  <- numeric(length(resp))
            for (i in 1:length(resp))
              {
                mlik[i] <- stops[i,class[i]+1]
              }
            mlik  <- stops[,class+1]
            print(paste("Estimated mcr:", mcrl, "achieved after",
                        round(mean(mlik),2), "boosting step(s)"))
          }
        if (grafik)
          {
            xax <- "Boosting steps"
            yax <- "Error rate"
            ttl <- "LogitBoost"
            plot(mcra, xlab=xax, ylab=yax, main=ttl, type="l")
          }
      }
  }

