% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av.R
\name{av-defunct}
\alias{av-defunct}
\alias{avtable_paged}
\alias{avtable_import_status}
\alias{avdata}
\alias{avdata_import}
\alias{avbucket}
\alias{avfiles_ls}
\alias{avfiles_backup}
\alias{avfiles_restore}
\alias{avfiles_rm}
\alias{avruntimes}
\alias{avruntime}
\alias{avdisks}
\title{TABLE, DATA, files, bucket, runtime, and disk elements}
\usage{
avtable_paged(
  table,
  n = Inf,
  page = 1L,
  pageSize = 1000L,
  sortField = "name",
  sortDirection = c("asc", "desc"),
  filterTerms = character(),
  filterOperator = c("and", "or"),
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  na = c("", "NA")
)

avtable_import_status(
  job_status,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avdata(namespace = avworkspace_namespace(), name = avworkspace_name())

avdata_import(
  .data,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avbucket(
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  as_path = TRUE
)

avfiles_ls(
  path = "",
  full_names = FALSE,
  recursive = FALSE,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avfiles_backup(
  source,
  destination = "",
  recursive = FALSE,
  parallel = TRUE,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avfiles_restore(
  source,
  destination = ".",
  recursive = FALSE,
  parallel = TRUE,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avfiles_rm(
  source,
  recursive = FALSE,
  parallel = TRUE,
  namespace = avworkspace_namespace(),
  name = avworkspace_name()
)

avruntimes()

avruntime(project = gcloud_project(), account = gcloud_account())

avdisks()
}
\arguments{
\item{table}{character(1) table name as returned by, e.g., \code{avtables()}.}

\item{n}{numeric(1) maximum number of rows to return}

\item{page}{integer(1) first page of iteration}

\item{pageSize}{integer(1) number of records per page. Generally,
larger page sizes are more efficient.}

\item{sortField}{character(1) field used to sort records when
determining page order. Default is the entity field.}

\item{sortDirection}{character(1) direction to sort entities
(\code{"asc"}ending or \code{"desc"}ending) when paging.}

\item{filterTerms}{character(1) string literal to select rows with
an exact (substring) matches in column.}

\item{filterOperator}{character(1) operator to use when multiple
terms in \verb{filterTerms=}, either \code{"and"} (default) or \code{"or"}.}

\item{namespace}{character(1) AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{character(1) AnVIL workspace name as returned by, eg.,
\code{avworkspace_name()}.}

\item{na}{in \code{avtable()} and \code{avtable_paged()}, character() of
strings to be interpretted as missing values. In
\code{avtable_import()} character(1) value to use for representing
\code{NA_character_}. See Details.}

\item{job_status}{tibble() of job identifiers, returned by
\code{avtable_import()} and \code{avtable_import_set()}.}

\item{.data}{A tibble or data.frame for import as an AnVIL table.}

\item{as_path}{logical(1) when TRUE (default) return bucket with
prefix \verb{gs://} (for \code{avbucket()}) or \verb{gs://<bucket-id>} (for
\code{avfiles_ls()}).}

\item{path}{For \verb{avfiles_ls(), the character(1) file or directory path to list. For }avfiles_rm()\verb{, the character() (perhaps with length greater than 1) of files or directory paths to be removed. The elements of }path\verb{can contain glob-style patterns, e.g.,}vign*`.}

\item{full_names}{logical(1) return names relative to \code{path}
(\code{FALSE}, default) or root of the workspace bucket?}

\item{recursive}{logical(1) list files recursively?}

\item{source}{character() file paths. for \code{avfiles_backup()},
\code{source} can include directory names when \code{recursive = TRUE}.}

\item{destination}{character(1) a google bucket
(\verb{gs://<bucket-id>/...}) to write files. The default is the
workspace bucket.}

\item{parallel}{logical(1) backup files using parallel transfer?
See \code{?gsutil_cp()}.}

\item{project}{\code{character(1)} project (billing account) name, as
returned by, e.g., \code{gcloud_project()} or
\code{avworkspace_namespace()}.}

\item{account}{\code{character(1)} google account (email address
associated with billing account), as returned by
\code{gcloud_account()}.}
}
\value{
\code{avtable_paged()}: a tibble of data corresponding to the
AnVIL table \code{table} in the specified workspace.

\code{avdata()} returns a tibble with five columns: \code{"type"}
represents the origin of the data from the 'REFERENCE' or
'OTHER' data menus. \code{"table"} is the table name in the
\code{REFERENCE} menu, or 'workspace' for the table in the 'OTHER'
menu, the key used to access the data element, the value label
associated with the data element and the value (e.g., google
bucket) of the element.

\code{avdata_import()} returns, invisibly, the subset of the
input table used to update the AnVIL tables.

\code{avbucket()} returns a \code{character(1)} bucket identifier,
prefixed with \verb{gs://} if \code{as_path = TRUE}.

\code{avfiles_ls()} returns a character vector of files in the
workspace bucket.

\code{avfiles_backup()} returns, invisibly, the status code of the
\code{gsutil_cp()} command used to back up the files.

\code{avfiles_rm()} on success, returns a list of the return
codes of \code{gsutil_rm()}, invisibly.

\code{avruntimes()} returns a tibble with columns
\itemize{
\item id: integer() runtime identifier.
\item googleProject: character() billing account.
\item tool: character() e.g., "Jupyter", "RStudio".
\item status character() e.g., "Stopped", "Running".
\item creator character() AnVIL account, typically "user@gmail.com".
\item createdDate character() creation date.
\item destroyedDate character() destruction date, or NA.
\item dateAccessed character() date of (first?) access.
\item runtimeName character().
\item clusterServiceAccount character() service ('pet') account for
this runtime.
\item masterMachineType character() It is unclear which 'tool' populates
which of the machineType columns).
\item workerMachineType character().
\item machineType character().
\item persistentDiskId integer() identifier of persistent disk (see
\code{avdisks()}), or \code{NA}.
}

\code{avruntime()} returns a tibble witht he same structure as
the return value of \code{avruntimes()}.

\code{avdisks()} returns a tibble with columns
\itemize{
\item id character() disk identifier.
\item googleProject: character() billing account.
\item status, e.g, "Ready"
\item size integer() in GB.
\item diskType character().
\item blockSize integer().
\item creator character() AnVIL account, typically "user@gmail.com".
\item createdDate character() creation date.
\item destroyedDate character() destruction date, or NA.
\item dateAccessed character() date of (first?) access.
\item zone character() e.g.. "us-central1-a".
\item name character().
}
}
\description{
DEFUNCT - AnVIL GCP functions for TABLE, DATA, files, bucket,

\code{avtable_import_status()} queries for the status of an
'asynchronous' table import.

\code{avdata()} returns key-value tables representing the
information visualized under the DATA tab, 'REFERENCE DATA' and
'OTHER DATA' items.  \code{avdata_import()} updates (modifies or
creates new, but does not delete) rows in 'REFERENCE DATA' or
'OTHER DATA' tables.

\code{avbucket()} returns the workspace bucket, i.e., the
google bucket associated with a workspace. Bucket content can
be visualized under the 'DATA' tab, 'Files' item.

\code{avfiles_ls()} returns the paths of files in the
workspace bucket.  \code{avfiles_backup()} copies files from the
compute node file system to the workspace bucket.
\code{avfiles_restore()} copies files from the workspace bucket to
the compute node file system.  \code{avfiles_rm()} removes files or
directories from the workspace bucket.

\code{avruntimes()} returns a tibble containing information
about runtimes (notebooks or RStudio instances, for example)
that the current user has access to.

\code{avruntime()} returns a tibble with the runtimes
associated with a particular google project and account number;
usually there is a single runtime satisfiying these criteria,
and it is the runtime active in AnVIL.

'avdisks()` returns a tibble containing information
about persistent disks associatd with the current user.
}
\details{
\code{avfiles_backup()} can be used to back-up individual files
or entire directories, recursively.  When \code{recursive = FALSE},
files are backed up to the bucket with names approximately
\code{paste0(destination, "/", basename(source))}.  When \code{recursive = TRUE} and source is a directory \verb{path/to/foo/', files are backed up to bucket names that include the directory name, approximately }paste0(destination, "/", dir(basename(source),
full.names = TRUE))\verb{.  Naming conventions are described in detail in }gsutil_help("cp")`.

\code{avfiles_restore()} behaves in a manner analogous to
\code{avfiles_backup()}, copying files from the workspace bucket to
the compute node file system.
}
