% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcloud.R
\name{gcloud-defunct}
\alias{gcloud-defunct}
\alias{gcloud}
\alias{gcloud_exists}
\alias{gcloud_account}
\alias{gcloud_project}
\alias{gcloud_help}
\alias{gcloud_cmd}
\alias{gcloud_storage}
\alias{gcloud_storage_buckets}
\title{DEFUNCT - gcloud command line utility interface}
\usage{
gcloud_exists()

gcloud_account(account = NULL)

gcloud_project(project = NULL)

gcloud_help(...)

gcloud_cmd(cmd, ...)

gcloud_storage(cmd, ...)

gcloud_storage_buckets(bucket_cmd = "create", bucket, ...)
}
\arguments{
\item{account}{character(1) Google account (e.g., \code{user@gmail.com})
to use for authentication.}

\item{project}{character(1) billing project name.}

\item{...}{Additional arguments appended to gcloud commands.}

\item{cmd}{\code{character(1)} representing a command used to evaluate
\verb{gcloud cmd ...}.}

\item{bucket_cmd}{\code{character(1)} representing a buckets command typically
used to create a new bucket. It can also be used to
\code{add-iam-policy-binding} or \code{remove-iam-policy-binding} to a bucket.}

\item{bucket}{\code{character(1)} representing a unique bucket name to be created
or modified.}
}
\value{
\code{gcloud_exists()} returns \code{TRUE} when the \code{gcloud}
application can be found, FALSE otherwise.

\code{gcloud_account()} returns a \code{character(1)} vector
containing the active gcloud account, typically a gmail email
address.

\code{gcloud_project()} returns a \code{character(1)} vector
containing the active gcloud project.

\code{gcloud_help()} returns an unquoted \code{character()} vector
representing the text of the help manual page returned by
\verb{gcloud help ...}.

\code{gcloud_cmd()} returns a \code{character()} vector representing
the text of the output of \verb{gcloud cmd ...}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\cr
These functions invoke the \code{gcloud} command line utility. See \link{gsutil}
for details on how \code{gcloud} is located.

\code{gcloud_exists()} tests whether the \code{gcloud()} command
can be found on this system. After finding the binary location,
it runs \verb{gcloud version} to identify potentially misconfigured
installations. See 'Details' section of \code{gsutil} for where the
application is searched.

\code{gcloud_account()}: report the current gcloud account
via \verb{gcloud config get-value account}.

\code{gcloud_project()}: report the current gcloud project
via \verb{gcloud config get-value project}.

\code{gcloud_help()}: queries \code{gcloud} for help for a
command or sub-comand via \verb{gcloud help ...}.

\code{gcloud_cmd()} allows arbitrary \code{gcloud} command
execution via \verb{gcloud ...}. Use pre-defined functions in
preference to this.

\code{gcloud_storage()} allows arbitrary \verb{gcloud storage} command
execution via \verb{gcloud storage ...}. Typically used for bucket management
commands such as \code{rm} and \code{cp}.

\code{gcloud_storage_buckets()} provides an interface to the
\verb{gcloud storage buckets} command. This command can be used to create a new
bucket via \verb{gcloud storage buckets create ...}.
}
