% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_len_compute.R
\name{eff_len_compute}
\alias{eff_len_compute}
\title{Compute the median effective length of transcripts.}
\usage{
eff_len_compute(x_eff_len)
}
\arguments{
\item{x_eff_len}{is a list: each element of the list refers to a specific sample and is a matrix or data.frame
with the estimated effective length under the column 'EffectiveLength' and the transcript name under the column 'Name'.}
}
\value{
A vector containing the effective length of transcripts; the vector names indicate the transcript ids.
}
\description{
\code{eff_len_compute} inputs the estimated effective length of transcripts from every sample, and
computes the median effective length of each transcript across samples.
}
\examples{
# specify the directory of the internal data:
data_dir = system.file("extdata", package = "BANDITS")

# Specify the directory of the transcript level estimated counts.
quant_files = file.path(data_dir, "STAR-salmon", paste0("sample", seq_len(4)), "quant.sf")

# Load the transcript level estimated counts via tximport:
library(tximport)
txi = tximport(files = quant_files, type = "salmon", txOut = TRUE)

# compute the Median estimated effective length for each transcript:
eff_len = eff_len_compute(x_eff_len = txi$length)
head(eff_len)

}
\seealso{
\code{\link{filter_transcripts}}, \code{\link{create_data}}
}
\author{
Simone Tiberi \email{simone.tiberi@uzh.ch}
}
