% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocPkgRanges.R
\name{biocPkgRanges}
\alias{biocPkgRanges}
\title{Grab build report results from BUILD_STATUS_DB for a particular package range}
\usage{
biocPkgRanges(
  start,
  end,
  condition = c("ERROR", "WARNINGS"),
  phase = "buildsrc",
  version = c("devel", "release")
)
}
\arguments{
\item{start}{character(1) alphabetically first package name in range}

\item{end}{character(1) alphabetically last package name in range}

\item{condition}{character(1) condition string, typically 'ERROR' or
'WARNING'}

\item{phase}{character(1) string for phase of event:
'install', 'checksrc', or 'buildsrc' (default)}

\item{version}{character(1) string indication Bioconductor version, either
'devel' (default) or 'release'}
}
\description{
Grab build report results from BUILD_STATUS_DB for a particular package range
}
\examples{
\dontrun{
biocPkgRanges(
    start = "a4", end = "CMA",
    condition = "ERROR", version = "devel"
)
}
}
\author{
Vincent J. Carey
}
