% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildPkgDependencyGraph.R
\name{buildPkgDependencyDataFrame}
\alias{buildPkgDependencyDataFrame}
\title{Work with Bioconductor package dependencies}
\usage{
buildPkgDependencyDataFrame(dependencies = c("strong", "most", "all"), ...)
}
\arguments{
\item{dependencies}{character() a vector listing the types of dependencies, a
subset of c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances").
Character string "all" is shorthand for that vector, character string
"most" for the same vector without "Enhances", character string "strong"
(default) for the first three elements of that vector.}

\item{...}{parameters passed along to \code{\link{biocPkgList}}}
}
\value{
A \code{data.frame} (also a \code{tbl_df}) of
S3 class "biocDepDF" including columns "Package", "dependency",
and "edgetype".
}
\description{
Bioconductor is built using an extensive set of
core capabilities and data structures. This leads
to package developers depending on other packages
for interoperability and functionality. This
function extracts package dependency information
from \code{\link{biocPkgList}} and returns a tidy
\code{data.frame} that can be used for analysis
and to build graph structures of package dependencies.
}
\note{
This function requires network access.
}
\examples{
# performs a network call, so must be online.
library(BiocPkgTools)
depdf <- buildPkgDependencyDataFrame()
head(depdf)
library(dplyr)
# filter to include only "Imports" type
# dependencies
imports_only <- depdf |> filter(edgetype=='Imports')

# top ten most imported packages
imports_only |> select(dependency) |>
  group_by(dependency) |> tally() |>
  arrange(desc(n))

# The Bioconductor packages with the
# largest number of imports
largest_importers <- imports_only |>
  select(Package) |>
  group_by(Package) |> tally() |>
  arrange(desc(n))

# not sure what these packages do. Join
# to their descriptions
biocPkgList() |> select(Package, Description) |>
  left_join(largest_importers) |> arrange(desc(n)) |>
  head()
}
\seealso{
See \code{\link{buildPkgDependencyIgraph}}, \code{\link{biocPkgList}}.
}
