% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/githubUtils.R
\name{githubDetails}
\alias{githubDetails}
\title{Get package details from GitHub}
\usage{
githubDetails(pkgs, sleep = 0)
}
\arguments{
\item{pkgs}{a character() vector of username/repo
for one or more GitHub repos, such as \code{seandavi/GEOquery}.}

\item{sleep}{numeric() denoting the number of seconds to
sleep between GitHub API calls. Since GitHub rate limits
its APIs, it might be necessary to either use small
chunks of packages iteratively or to supply a non-zero
argument here. See the \code{details} section for a better
solution using GitHub tokens.}
}
\description{
For packages that live on GitHub, we can mine
further details. This function returns the
GitHub details for the listed packages.
}
\details{
The \code{\link[gh]{gh}} function is used to
do the fetching. If the number of packages supplied
to this function is large (>40 or so), it is possible
to run into problems with API rate limits. The \code{gh}
package uses the environment variable "GITHUB_PAT"
(for personal access token) to authenticate and then
provide higher rate limits. If you run into problems
with rate limits, set sleep to some small positive
number to slow queries. Alternatively, create a Personal
Access Token on GitHub and register it. See the \code{gh}
package for details.
}
\examples{
pkglist = biocPkgList()

# example of "pkgs" format.
head(pkglist$URL)

gh_list = githubURLParts(pkglist$URL)
gh_list = gh_list[!is.null(gh_list$user_repo),]

head(gh_list$user_repo)

ghd = githubDetails(gh_list$user_repo[1:5])
lapply(ghd, '[[', "stargazers")

}
