% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgBiocDeps.R
\name{pkgBiocRevDeps}
\alias{pkgBiocRevDeps}
\alias{summary.biocrevdeps}
\title{Obtain all the reverse dependencies for a Bioconductor package}
\usage{
pkgBiocRevDeps(
  pkg,
  pkgType = c("software", "data-experiment", "workflows", "data-annotation"),
  which = "all",
  only.bioc = TRUE,
  version = BiocManager::version()
)

\method{summary}{biocrevdeps}(object, ...)
}
\arguments{
\item{pkg}{\code{character(1)} The package for which to look up dependencies.}

\item{pkgType}{\code{character()} Any of 'software', 'data-experiment',
'workflows', and / or 'data-annotation' (defaults to all)}

\item{which}{a character vector listing the types of
    dependencies, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
    Character string \code{"all"} is shorthand for that vector,
    character string \code{"most"} for the same vector without
    \code{"Enhances"},
    character string \code{"strong"} (default) for the first three
    elements of that vector.
  }

\item{only.bioc}{\code{logical(1)} Whether to only return Bioconductor
dependencies in the list (default \code{TRUE})}

\item{version}{(Optional) \code{character(1)} or \code{package_version}
indicating the \emph{Bioconductor} version (e.g., "3.8") for which
repositories are required.}

\item{object}{an object for which a summary is desired.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A \code{biocrevdeps} list class object
}
\description{
The function returns a slightly upgraded list with dependency types as
elements and package names in each of those elements, if any. The
types of dependencies can be seen in the \code{which} argument documentation.
}
\details{
The summary method of the \code{biocrevdeps} class given by
\code{pkgBiocRevDeps} provides a tally in each dependency field.
}
\examples{
rdeps <- pkgBiocRevDeps("MultiAssayExperiment", which = "all")
rdeps
summary(rdeps)
}
