% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDependencyMetrics.R
\name{pkgCombDependencyGain}
\alias{pkgCombDependencyGain}
\title{Calculate dependency gain achieved by excluding combinations of packages}
\usage{
pkgCombDependencyGain(pkg, depdf, maxNbr = 3L)
}
\arguments{
\item{pkg}{character, the name of the package for which we want
to estimate the dependency gain}

\item{depdf}{a tidy data frame with package dependency information
obtained through the function \code{\link{buildPkgDependencyDataFrame}}}

\item{maxNbr}{numeric, the maximal number of direct dependencies to leave
out simultaneously}
}
\value{
A data frame with three columns: ExclPackages (the excluded direct
dependencies), NbrExcl (the number of excluded direct dependencies),
DepGain (the dependency gain from excluding these direct dependencies)
}
\description{
Calculate dependency gain achieved by excluding combinations of packages
}
\examples{
depdf <- buildPkgDependencyDataFrame(
  dependencies=c("Depends", "Imports"), 
  repo=c("BioCsoft", "CRAN")
)
pcd <- pkgCombDependencyGain('GEOquery', depdf, maxNbr = 3L)
head(pcd[order(pcd$DepGain, decreasing = TRUE), ])

}
\author{
Charlotte Soneson
}
