% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercions.R
\name{as.Seurat}
\alias{as.Seurat}
\alias{as.Seurat.NanoStringGeoMxSet}
\title{Convert GeoMxSet Object to SeuratObject}
\usage{
\method{as.Seurat}{NanoStringGeoMxSet}(
  x,
  ident = NULL,
  normData = NULL,
  coordinates = NULL,
  forceRaw = FALSE,
  ...
)
}
\arguments{
\item{x}{An object to convert to class \code{Seurat}}

\item{ident}{column in GeoMxSet segmentProperties to set as Seurat object's identity class}

\item{normData}{assay containing normalized data}

\item{coordinates}{X and Y coordinates of each ROI, format: c(X,Y)}

\item{forceRaw}{should raw data be forced into SeuratObject, not recommended}

\item{...}{Arguments passed to other methods}
}
\value{
SeuratObject containing GeoMx data
}
\description{
Convert GeoMxSet Object to SeuratObject
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data", package = "GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))

target_demoData <- aggregateCounts(demoData[1:1000,1:10])

target_demoData <- normalize(target_demoData, "quant")

seurat_demoData <- as.Seurat(target_demoData, ident = "cell_line",
                             normData = "exprs_norm", forceRaw = FALSE)

}
\seealso{
\code{\link[SeuratObject:as.Seurat]{SeuratObject::as.Seurat}}
}
\concept{objects}
