% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-qc.R
\name{setGeoMxQCFlags}
\alias{setGeoMxQCFlags}
\title{Add GeoMx segment QC flags to NanoStringGeoMxSet object protocol data}
\usage{
setGeoMxQCFlags(object, qcCutoffs = DEFAULTS)
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object to perform QC on}

\item{qcCutoffs}{a list of qc cutoffs to use
\enumerate{
    \item{minNuclei, 
          numeric to flag segments with less than this number of nuclei}
    \item{minArea, 
          numeric to flag segments with less than this um^2 area}
}}
}
\value{
\code{NanoStringGeoMxSet} object with \code{QCFlags} data frame 
        appended to \code{protocolData}
}
\description{
Add GeoMx segment QC flags to NanoStringGeoMxSet object protocol data
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
setGeoMxQCFlags(demoData[,1:10], 
                 qcCutoffs=list(minNuclei=16000, 
                                minArea=20))

}
