% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterWeakPositions.R
\name{filterWeakPositions}
\alias{filterWeakPositions}
\title{Filter weak positions.}
\usage{
filterWeakPositions(object, threshold = NULL)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{threshold}{The minimum average interaction for a position to be kept. If a position's
average interaction with the entire chromosome is lower than this value in
any of the replicates, it is removed from all replicates and conditions.
Defaults to \code{object$smallChromosomeThreshold} which is originally set to
\code{defaultHiCDOCParameters$smallChromosomeThreshold} = 1.}
}
\value{
A filtered \code{\link{HiCDOCDataSet}}.
}
\description{
Removes weak genomic positions whose interactions average is lower than the
threshold.
}
\details{
Detects weak genomic positions in each replicate, and removes them from all
replicates to guarantee comparability across conditions when calling
\code{\link{detectCompartments}}.
}
\examples{
data(exampleHiCDOCDataSet)
object <- exampleHiCDOCDataSet

object <- filterWeakPositions(object)

}
\seealso{
\code{\link{filterSmallChromosomes}},
\code{\link{filterSparseReplicates}},
\code{\link{HiCDOC}}
}
