% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeTechnicalBiases.R
\name{normalizeTechnicalBiases}
\alias{normalizeTechnicalBiases}
\title{Normalize technical biases.}
\usage{
normalizeTechnicalBiases(object, parallel = FALSE, cyclicLoessSpan = NULL)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{parallel}{Logical. Whether or not to parallelize the processing. Defaults to FALSE}

\item{cyclicLoessSpan}{A numeric value in between 0 and 1. The span for cyclic loess normalization. 
This value is passed to \code{multiHiCcompare::cyclic_loess}. 
Defaults to NULL, NULL indicates that the value of 
parameters(object)$cyclicLoessSpan will be used. 
If this value is NA, the span will be automatically calculated using 
generalized cross validation. **For large dataset, it is highly recommended 
to set this value to reduce computing time and necessary memory.**}
}
\value{
A \code{\link{HiCDOCDataSet}} with normalized interactions.
}
\description{
Normalizes technical biases such as sequencing depth by using a cyclic loess
to recursively normalize each pair of interaction matrices. Depends on
\code{multiHiCcompare}.
}
\details{
\subsection{Parallel processing}{
If \code{parallel = TRUE}, the function
\code{\link[multiHiCcompare]{cyclic_loess}}
is launched in parallel mode, using \code{\link[BiocParallel]{bplapply}}
function. Before to call the function in parallel you should specify
the parallel parameters such as:
    \itemize{
        \item{On Linux:

             \code{multiParam <- BiocParallel::MulticoreParam(workers = 10)}
         }
         \item{On Windows:

             \code{multiParam <- BiocParallel::SnowParam(workers = 10)}
        }
    }
    And then you can register the parameters to be used by BiocParallel:

    \code{BiocParallel::register(multiParam, default = TRUE)}
}
}
\examples{
data(exampleHiCDOCDataSet)
object <- filterSmallChromosomes(exampleHiCDOCDataSet)
object <- filterSparseReplicates(object)
object <- filterWeakPositions(object)
# Not printing loess warnings for example purpose. 
# Results should be inspected if there is any.
suppressWarnings(
    object <- normalizeTechnicalBiases(object)
)


}
\seealso{
\code{\link{filterSparseReplicates}},
\code{\link{filterWeakPositions}},
\code{\link{normalizeBiologicalBiases}},
\code{\link{normalizeDistanceEffect}},
\code{\link{HiCDOC}}
}
