% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCompartments.R
\name{plotCompartments}
\alias{plotCompartments}
\title{Plot A/B compartments.}
\usage{
plotCompartments(object, chromosome, xlim = NULL, colour = "gray90")
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{chromosome}{A chromosome name or index in \code{chromosomes(object)}.}

\item{xlim}{A vector of the minimum and maximum positions to display. If NULL, displays
all positions. Defaults to NULL.}

\item{colour}{Border color for the compartments. Default to `gray90`. `NA` means no border.}
}
\value{
A \code{ggplot}.
}
\description{
Plots the predicted compartments in each experiment condition.
}
\examples{
data(exampleHiCDOCDataSetProcessed)
plotCompartments(exampleHiCDOCDataSetProcessed, chromosome = 1)

}
