% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistanceEffect.R
\name{plotDistanceEffect}
\alias{plotDistanceEffect}
\title{Plot the distance effect.}
\usage{
plotDistanceEffect(
  object,
  chromosome = NULL,
  transformX = "identity",
  transformY = "identity"
)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{chromosome}{Name (character) or index of the chromosome, if the plot should be
restricted to only one chromosome. Default to NULL.}

\item{transformX}{Transformation of the X axis. Default to "identity". See
\code{\link[ggplot2]{scale_x_continuous}} for other accepted values.}

\item{transformY}{Transformation of the Y axis. Default to "identity". See
\code{\link[ggplot2]{scale_y_continuous}} for other accepted values.}
}
\value{
A \code{ggplot}.
}
\description{
Plots the distance effect on proportion of interactions.
Each point is a cell in the interaction matrix, such that
the x-axis is the distance with respect to the diagonal,
the y-axis is number of counts.
Dots are binned.
}
\examples{
data(exampleHiCDOCDataSet)
plotDistanceEffect(exampleHiCDOCDataSet)

}
