% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonLiP.R
\name{groupComparisonLiP}
\alias{groupComparisonLiP}
\title{Model LiP and TrP data and make adjustments if needed
Returns list of three modeled datasets}
\usage{
groupComparisonLiP(
  data,
  contrast.matrix = "pairwise",
  fasta.path = NULL,
  log_base = 2,
  use_log_file = FALSE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  base = "MSstatsLiP_log_"
)
}
\arguments{
\item{data}{list of summarized datasets. Can be output of MSstatsLiP
summarization function \code{\link[MSstatsLiP]{dataSummarizationLiP}}. Must
include dataset named "LiP" as minimum.}

\item{contrast.matrix}{comparison between conditions of interests. Default
models full pairwise comparison between all conditions}

\item{fasta.path}{a file path to a fasta file that includes the proteins
listed in the data. Default is NULL. Include this parameter to determine
trypticity of peptides in LiP models.}

\item{log_base}{base of the logarithm used in dataProcess.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be
added to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing will be
printed to the console.}

\item{log_file_path}{character. Path to a file to which information about
data processing will be saved.
If not provided, such a file will be created automatically.
If \code{append = TRUE}, has to be a valid path to a file.}

\item{base}{start of the file name.}
}
\value{
list of modeling results. Includes LiP, PROTEIN, and ADJUSTED LiP
data.tables with their corresponding model results.
}
\description{
Takes summarized LiP peptide and TrP protein data from dataSummarizationLiP
If global protein data is unavailable, LiP data only can be passed into the
function. Including protein data allows for adjusting LiP Fold Change by the
change in global protein abundance..
}
\examples{

## Use output of dataSummarizationLiP function
fasta <- system.file("extdata", "ExampleFastaFile.fasta", package="MSstatsLiP")

# Test for pairwise comparison
MSstatsLiP_model <- groupComparisonLiP(MSstatsLiP_Summarized,
                                   contrast.matrix = "pairwise",
                                   fasta.path = fasta)

# Returns list of three models
names(MSstatsLiP_model)
head(MSstatsLiP_model$LiP.Model)
head(MSstatsLiP_model$TrP.Model)
head(MSstatsLiP_model$Adjusted.LiP.Model)

}
