% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_source_class.R
\name{annotation_source}
\alias{annotation_source}
\title{An annotation source}
\usage{
annotation_source(source = character(0), data = data.frame(), tag = "", ...)
}
\arguments{
\item{source}{(ANY) The source of annotation data. The default is
\code{character(0)}.}

\item{data}{(data.frame, NULL) A data.frame of annotation data. The
default is \code{data.frame()}.}

\item{tag}{(character) A (short) character string that is used to
represent this source e.g. in column names or source columns when
used in a workflow. The default is \code{""}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A \code{
annotation_source
} object. This object has no \code{output} slots.
}
\description{
A base class defining an annotation source. This object
is extended by MetmashR to define other objects.
}
\section{Inheritance}{

A \code{annotation_source} object inherits the following \code{struct} classes:
\cr\cr
\verb{[annotation_source]} -> \verb{[struct_class]}
}

\examples{
M <- annotation_source(
        tag = character(0),
        data = data.frame(),
        source = "ANY")

}
\seealso{
Other annotation databases: 
\code{\link{AnnotationDb_database}},
\code{\link{GO_database}},
\code{\link{annotation_database}},
\code{\link{excel_database}},
\code{\link{rdata_database}},
\code{\link{rds_cache}},
\code{\link{rds_database}}
}
\concept{annotation databases}
