% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggdiffbartaxa.R
\name{get_mean_median}
\alias{get_mean_median}
\title{get the mean and median of specific feature.}
\usage{
get_mean_median(datameta, feature, subclass)
}
\arguments{
\item{datameta}{data.frame, nrow sample * ncol feature + factor.}

\item{feature}{character vector, the feature contained in datameta.}

\item{subclass}{character, factor name.}
}
\value{
featureMeanMedian object, contained the abundance of feature, and the 
mean and median of feature by subclass.
}
\description{
get the mean and median of specific feature.
}
\examples{
\dontrun{
    data(hmp_aerobiosis_small)
    head(sampleda)
    featureda <- merge(featureda, sampleda, by=0)
    rownames(featureda) <- as.vector(featureda$Row.names)
    featureda$Row.names <- NULL
    feameamed <- get_mean_median(datameta=featureda, 
                        feature="p__Actinobacteria", 
                        subclass="body_site")
    fplot <- ggdifftaxbar(feameamed, featurename="p__Actinobacteria", 
                         classgroup="oxygen_availability", subclass="body_site")
}
}
\author{
Shuangbin Xu
}
