% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_abundance.R
\name{get_taxadf}
\alias{get_taxadf}
\alias{get_taxadf,phyloseq-method}
\alias{get_taxadf,phyloseq}
\alias{get_taxadf,data.frame-method}
\alias{get_taxadf,data.frame}
\title{get the data of specified taxonomy}
\usage{
get_taxadf(obj, ...)

\S4method{get_taxadf}{phyloseq}(obj, taxlevel = 2, type = "species", ...)

\S4method{get_taxadf}{data.frame}(
  obj,
  taxda,
  taxa_are_rows,
  taxlevel,
  sampleda = NULL,
  type = "species",
  ...
)
}
\arguments{
\item{obj}{phyloseq, phyloseq class or data.frame
the shape of data.frame (nrow sample * column feature
taxa_are_rows set FALSE, nrow feature * ncol sample, 
taxa_are_rows set TRUE).}

\item{..., }{additional parameters.}

\item{taxlevel}{character, the column names of taxda that you want to get.
when the input is phyloseq class, you can use 1 to 7.}

\item{type}{character, the type of datasets, default is "species", 
if the dataset is not about species, such as dataset of kegg function, 
you should set it to "others".}

\item{taxda}{data.frame, the classifies of feature contained 
in obj(data.frame).}

\item{taxa_are_rows}{logical, if the column of data.frame
are features, it should be set FALSE.}

\item{sampleda}{data.frame, the sample information.}
}
\value{
phyloseq class contained tax data.frame and sample information.
}
\description{
get the data of specified taxonomy
}
\examples{
\dontrun{
library(ggplot2)
data(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
phytax <- get_taxadf(test_otu_data, taxlevel=2)
phytax
head(phyloseq::otu_table(phytax))
phybar <- ggbartax(phytax) + 
         xlab(NULL) + ylab("relative abundance (\%)")
}
}
\author{
Shuangbin Xu
}
