% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_metadata.R
\name{browseSRA}
\alias{browseSRA}
\title{Open SRA in browser for specific bioproject}
\usage{
browseSRA(x, browser = getOption("browser"))
}
\arguments{
\item{x}{character, bioproject ID.}

\item{browser}{a non-empty character string giving the name of the
    program to be used as the HTML browser.  It should be in the PATH,
    or a full path specified.  Alternatively, an \R function to be
    called to invoke the browser.

    Under Windows \code{NULL} is also allowed (and is the default), and
    implies that the file association mechanism will be used.
  }
}
\value{
invisible(NULL), opens webpage only
}
\description{
Open SRA in browser for specific bioproject
}
\examples{
#browseSRA("PRJNA336542")

#' # For windows make sure a valid browser is defined:
browser <- getOption("browser")
#browseSRA("PRJNA336542", browser)
}
\seealso{
Other sra: 
\code{\link{download.SRA}()},
\code{\link{download.SRA.metadata}()},
\code{\link{download.ebi}()},
\code{\link{get_bioproject_candidates}()},
\code{\link{install.sratoolkit}()},
\code{\link{rename.SRA.files}()}
}
\concept{sra}
