% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riboseq_features.R
\name{insideOutsideORF}
\alias{insideOutsideORF}
\title{Inside/Outside score (IO)}
\usage{
insideOutsideORF(
  grl,
  RFP,
  GtfOrTx,
  ds = NULL,
  RFP.sorted = FALSE,
  weight = 1L,
  overlapGrl = NULL
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
with usually either leaders, cds', 3' utrs or ORFs.}

\item{RFP}{RiboSeq reads as GAlignments, GRanges
or GRangesList object}

\item{GtfOrTx}{If it is \code{\link{TxDb}} object
transcripts will be extracted using
\code{exonsBy(Gtf, by = "tx", use.names = TRUE)}.
Else it must be \code{\link{GRangesList}}}

\item{ds}{numeric vector (NULL), disengagement score. If you have already
calculated \code{\link{disengagementScore}}, input here to save time.}

\item{RFP.sorted}{logical (FALSE), an optimizer, have you ran this line:
\code{RFP <- sort(RFP[countOverlaps(RFP, tx, type = "within") > 0])}
Normally not touched, for internal optimization purposes.}

\item{weight}{a numeric/integer vector or metacolumn name.
(default: 1L, no differential weighting).
If weight is name of defined meta column in reads object,
it gives the number of times a read was found at that position.
GRanges("chr1", 1, "+", score = 5), would mean "score" column tells
that this alignment region was found 5 times.
if 1L it means each read is weighted equal as 1,
this is what among others countOverlaps() presumes,
if single number (!= 1), it repeats for all ranges,
if vector with length > 1, it must be equal size of the
reads object.}

\item{overlapGrl}{an integer, (default: NULL),
if defined must be countOverlaps(grl, RFP),
added for speed if you already have it}
}
\value{
a named vector of numeric values of scores
}
\description{
Inside/Outside score is defined as
\preformatted{(reads over ORF)/(reads outside ORF and within transcript)}
A pseudo-count of one is added to both the ORF and outside sums.
}
\examples{
# Check inside outside score of a ORF within a transcript
ORF <- GRanges("1",
               ranges = IRanges(start = c(20, 30, 40),
                                  end = c(25, 35, 45)),
               strand = "+")

grl <- GRangesList(tx1_1 = ORF)

tx1 <- GRanges(seqnames = "1",
               ranges = IRanges(start = c(1, 10, 20, 30, 40, 50),
                                end = c(5, 15, 25, 35, 45, 200)),
               strand = "+")
tx <- GRangesList(tx1 = tx1)
RFP <- GRanges(seqnames = "1",
                  ranges = IRanges(start = c(1, 4, 30, 60, 80, 90),
                                   end = c(30, 33, 63, 90, 110, 120)),
                  strand = "+")

insideOutsideORF(grl, RFP, tx)

}
\references{
doi: 10.1242/dev.098345
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
