% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_class.R
\name{organism,experiment-method}
\alias{organism,experiment-method}
\title{Get ORFik experiment organism}
\usage{
\S4method{organism}{experiment}(object)
}
\arguments{
\item{object}{an ORFik \code{\link{experiment}}}
}
\value{
character, name of organism
}
\description{
If not defined directly, checks the txdb / gtf organism information, if existing.
}
\examples{
# if you have set organism in txdb of ORFik experiment:
df <- ORFik.template.experiment()
organism(df)

#' If you have not set the organism you can do:
#gtf <- "pat/to/gff_or_gff"
#txdb_path <- paste0(gtf, ".db") # This file is created in next step
#txdb <- makeTxdbFromGenome(gtf, genome, organism = "Homo sapiens",
# optimize = TRUE, return = TRUE)
# then use this txdb in you ORFik experiment and load:
# create.experiment(exper = "new_experiment",
#   txdb = txdb_path) ...
# organism(read.experiment("new-experiment))
}
\seealso{
Other ORFik_experiment: 
\code{\link{ORFik.template.experiment}()},
\code{\link{ORFik.template.experiment.zf}()},
\code{\link{bamVarName}()},
\code{\link{create.experiment}()},
\code{\link{experiment-class}},
\code{\link{filepath}()},
\code{\link{libraryTypes}()},
\code{\link{outputLibs}()},
\code{\link{read.experiment}()},
\code{\link{save.experiment}()},
\code{\link{validateExperiments}()}
}
\concept{ORFik_experiment}
