% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_plots.R
\name{pSitePlot}
\alias{pSitePlot}
\title{Plot area around TIS as histogram}
\usage{
pSitePlot(
  hitMap,
  length = unique(hitMap$fraction),
  region = "start",
  output = NULL,
  type = "canonical CDS",
  scoring = "Averaged counts",
  forHeatmap = FALSE,
  title = "auto",
  facet = FALSE,
  frameSum = FALSE
)
}
\arguments{
\item{hitMap}{a data.frame/data.table, given from metaWindow
(must have columns: position, (score or count) and frame)}

\item{length}{an integer (29), which read length is this for?}

\item{region}{a character (start), either "start or "stop"}

\item{output}{character (NULL), if set, saves the plot as pdf or png
to path given. If no format is given, is save as pdf.}

\item{type}{character (canonical CDS), type for plot}

\item{scoring}{character, default: (Averaged counts),
which scoring did you use ?
see ?coverageScorings for info and more alternatives.}

\item{forHeatmap}{a logical (FALSE), should the plot be part of
a heatmap? It will scale it differently. Removing title, x and y labels, and
truncate spaces between bars.}

\item{title}{character, title of plot. Default "auto", will make it:
paste("Length", length, "over", region, "of", type).
Else set your own (set to NULL to remove all together).}

\item{facet}{logical, default FALSE. If you input multiple read lengths,
specified by fraction column of hitMap, it will split the plots for
each read length, putting them under each other. Ignored if forHeatmap
is TRUE.}

\item{frameSum}{logical default FALSE. If TRUE, add an addition plot
to the right, sum per frame over all positions per length.}
}
\value{
a ggplot object of the coverage plot, NULL if output is set,
then the plot will only be saved to location.
}
\description{
Usefull to validate p-shifting is correct
Can be used for any coverage of region around a point, like TIS, TSS,
stop site etc.
}
\details{
The region is represented as a histogram with different colors for the
3 frames. To make it easy to see patterns in the reads.
Remember if you want to change anything like colors, just return the
ggplot object, and reassign like: obj + scale_color_brewer() etc.
}
\examples{
# An ORF
grl <- GRangesList(tx1 = GRanges("1", IRanges(1, 6), "+"))
# Ribo-seq reads
range <- IRanges(c(rep(1, 3), 2, 3, rep(4, 2), 5, 6), width = 1 )
reads <- GRanges("1", range, "+")
coverage <- coveragePerTiling(grl, reads, TRUE, as.data.table = TRUE,
                              withFrames = TRUE)
pSitePlot(coverage)
pSitePlot(coverage, frameSum = TRUE)
# See vignette for more examples

}
\seealso{
Other coveragePlot: 
\code{\link{coverageHeatMap}()},
\code{\link{savePlot}()},
\code{\link{windowCoveragePlot}()}
}
\concept{coveragePlot}
