% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_plots.R
\name{plotHelper}
\alias{plotHelper}
\title{Helper function for coverage plots}
\usage{
plotHelper(
  coverage,
  df,
  outdir,
  scores,
  returnCoverage = FALSE,
  title = "coverage metaplot",
  plot.ext = ".pdf",
  colors = c("skyblue4", "orange"),
  plotFunction = "windowCoveragePlot"
)
}
\arguments{
\item{coverage}{a data.table containing at least columns (count/score,
position), it is possible to have additionals: (genes, fraction, feature)}

\item{df}{an ORFik \code{\link{experiment}}}

\item{outdir}{directory to save to (default: NULL, no saving)}

\item{scores}{scoring function (default: c("sum", "transcriptNormalized")),
see ?coverageScorings for possible scores.}

\item{returnCoverage}{(defualt: FALSE), return the ggplot object (TRUE)
or NULL (FALSE).}

\item{title}{Title to give plot}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{colors}{Which colors to use, default auto color from function
\code{\link{experiment.colors}}, new color per library type.
Else assign colors yourself.}

\item{plotFunction}{Which plot function, default: windowCoveragePlot}
}
\value{
NULL (or ggplot object if returnCoverage is TRUE)
}
\description{
Should only be used internally
}
\keyword{internal}
