% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper.R
\name{check_DE_parameters}
\alias{check_DE_parameters}
\title{Check parameters for DE analysis}
\usage{
check_DE_parameters(
  se,
  ain = NULL,
  condition = NULL,
  comparisons = NULL,
  DE_method = "limma",
  covariate = NULL,
  logFC = TRUE,
  logFC_up = 1,
  logFC_down = -1,
  p_adj = TRUE,
  p_adj_method = "BH",
  alpha = 0.05,
  B = 100,
  K = 500,
  DEqMS_PSMs_column = NULL
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{Vector of strings which assay should be used as input (default NULL).
If NULL then all normalization of the se object are plotted next to each other.}

\item{condition}{column name of condition (if NULL, condition saved in SummarizedExperiment will be taken)}

\item{comparisons}{Vector of comparisons that are performed in the DE analysis (from specify_comparisons method)}

\item{DE_method}{String specifying which DE method should be applied (limma, ROTS, DEqMS)}

\item{covariate}{String specifying which column to include as covariate into limma}

\item{logFC}{Boolean specifying whether to apply a logFC threshold (TRUE) or not (FALSE)}

\item{logFC_up}{Upper log2 fold change threshold (dividing into up regulated)}

\item{logFC_down}{Lower log2 fold change threshold (dividing into down regulated)}

\item{p_adj}{Boolean specifying whether to apply a threshold on adjusted p-values (TRUE) or on raw p-values (FALSE)}

\item{p_adj_method}{String specifying the method for adjusted p-values}

\item{alpha}{Threshold for adjusted p-values or p-values}

\item{B}{Number of bootstrapping for ROTS}

\item{K}{Number of top-ranked features for reproducibility optimization}

\item{DEqMS_PSMs_column}{String specifying which column name to use for DEqMS (default NULL)}
}
\value{
list of checked assays and condition column name
}
\description{
Check parameters for DE analysis
}
\keyword{internal}
