% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationMethods.R
\name{normalize_se_single}
\alias{normalize_se_single}
\title{Normalize SummarizedExperiment object using different normalization methods}
\usage{
normalize_se_single(
  se,
  methods = NULL,
  on_raw = NULL,
  gamma.0 = 0.1,
  reduce_correlation_by = 1,
  NormicsVSN_quantile = 0.8,
  top_x = 50,
  VSN_quantile = 0.9
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{methods}{Vector of normalization methods to apply for normalizing the proteomics data of the SummarizedExperiment object (identifier of normalization methods can be retrieved using get_normalization_methods())}

\item{on_raw}{Logical indicating if the normalization should be performed on the raw data or on log2-transformed data. If on_raw = NULL(default), the normalization is performed on the default method specific on_raw setting (suggestion based on publications).}

\item{gamma.0}{Numeric representing the exponent of the weighted density of RobNorm normalization. When the sample size is small, the fitted population of some proteins could be locally trapped such that the variance of those proteins was very small under a large gamma. To avoid this, a small gamma is recommended. When sample size smaller than 40, then set gamma to 0.5 or 0.1.}

\item{reduce_correlation_by}{If the data is too big for the computation of the params, increase this parameter by 2,3,4.... The whole data will still be normalized, but the params are calculated on every second row etc.}

\item{NormicsVSN_quantile}{The quantile that is used for the resistant least trimmed sum of squares regression. A value of 0.8 means focusing on the central 80\% of the data, reducing the influence of outliers.}

\item{top_x}{Number of reference proteins extracted for the calculation of parameters}

\item{VSN_quantile}{Numeric of length 1. The quantile that is used for the resistant least trimmed sum of squares regression. (see vsn2 lts.quantile)}
}
\value{
SummarizedExperiment object with normalized data saved as assays
}
\description{
Normalize SummarizedExperiment object using different normalization methods
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- normalize_se_single(tuberculosis_TMT_se,
          methods = c("RobNorm", "Median", "NormicsVSN","VSN"),
          on_raw = NULL, gamma.0 = 0.1, reduce_correlation_by = 1,
          NormicsVSN_quantile = 0.8, top_x = 50, VSN_quantile = 0.9)

}
