% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpikeOverview.R
\name{plot_profiles_spiked}
\alias{plot_profiles_spiked}
\title{Plot profiles of the spike-in and background proteins using the log2 average protein intensities as a function of the different concentrations.}
\usage{
plot_profiles_spiked(se, xlab = "Concentration")
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{xlab}{String for the x-label of the plot}
}
\value{
ggplot object
}
\description{
Plot profiles of the spike-in and background proteins using the log2 average protein intensities as a function of the different concentrations.
}
\examples{
data(spike_in_se)
plot_profiles_spiked(spike_in_se, xlab = "Concentration")

}
