% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetOverview.R
\name{plot_upset}
\alias{plot_upset}
\title{Create an UpSet Plot from SummarizedExperiment Data}
\usage{
plot_upset(
  se,
  color_by = NULL,
  label_by = NULL,
  mb.ratio = c(0.7, 0.3),
  only_refs = FALSE
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{color_by}{String specifying the column to color the samples (If NULL, the condition column of the SummarizedExperiment object is used.)}

\item{label_by}{String specifying the column in the metadata used to label the samples for the UpSet plot}

\item{mb.ratio}{A numeric vector of length 2, specifying the barplot and matrix area ratios}

\item{only_refs}{Logical, if TRUE, only reference samples (ComRef) are included in the plot}
}
\value{
ggplot object
}
\description{
This function generates an UpSet plot from a given SummarizedExperiment object.
It allows for the visualization of overlaps between sets defined by a specific
column in the metadata. The function supports subsetting to reference samples
and customizable color mapping.
}
\examples{
data(tuberculosis_TMT_se)
plot_upset(tuberculosis_TMT_se, color_by = NULL, label_by = NULL,
           mb.ratio = c(0.7, 0.3), only_refs = FALSE)

}
