% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhosphoExperiment.R
\docType{class}
\name{PhosphoExperiment-class}
\alias{PhosphoExperiment-class}
\alias{PhosphoExperiment}
\alias{coerce,}
\alias{SummarizedExperiment,}
\alias{PhosphoExperiment-method}
\title{The PhosphoExperiment class}
\usage{
PhosphoExperiment(
  ...,
  UniprotID = c(),
  GeneSymbol = c(),
  Site = c(),
  Residue = c(),
  Sequence = c(),
  Localisation = c()
)
}
\arguments{
\item{...}{Arguments parsed, identical to those used to create 
\linkS4class{SummarizedExperiment}.}

\item{UniprotID}{A character vector of Uniprot ID}

\item{GeneSymbol}{A character vector of gene symbol}

\item{Site}{A numeric vector of phosphorylation site}

\item{Residue}{A character vector of site residue}

\item{Sequence}{A character vector of sequences}

\item{Localisation}{A localisation score.}
}
\description{
The PhosphoExperiment class
}
\examples{
data(phospho_L6_ratio)
quant <- as.matrix(phospho.L6.ratio)
uniprot <- as.character(sapply(strsplit(rownames(quant),";"), 
    function(x) x[[2]]))
symbol <- as.character(sapply(strsplit(rownames(quant),";"), 
    function(x) x[[2]]))
site <- as.numeric(gsub("[STY]","",sapply(strsplit(rownames(quant),";"), 
    function(x) x[[3]])))
res <- as.character(gsub("[0-9]","",sapply(strsplit(rownames(quant),";"), 
    function(x) x[[3]])))
seq <- as.character(sapply(strsplit(rownames(quant),";"), 
    function(x) x[[4]]))
phosData <- PhosphoExperiment(assays = list(Quantification = quant), 
    UniprotID = uniprot, Site = site, GeneSymbol = symbol, Residue = res, 
    Sequence = seq)

}
