% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{selectOverallPercent}
\alias{selectOverallPercent}
\title{Select phosphosite by percentage of quantification}
\usage{
selectOverallPercent(mat, percent, n, assay)
}
\arguments{
\item{mat}{a matrix (or PhosphoExperiment object) with rows correspond to 
phosphosites and columns correspond to samples in replicates for different 
treatments.}

\item{percent}{a percent from 0 to 1, specifying the percentage of quantified
values in across all samples for retaining a phosphosite for subsequent
analysis.}

\item{n}{an integer indicating n or more quantified values required for
retaining a phosphosite for subsequent analysis.}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}
}
\value{
a filtered matrix
}
\description{
Select phosphosites that have been quantified in more than a
given percentage of samples
}
\examples{

data('phospho.cells.Ins.sample')

phospho.cells.Ins.filtered <- selectOverallPercent(phospho.cells.Ins, 0.5)

# Before filtering
dim(phospho.cells.Ins)
# After filtering
dim(phospho.cells.Ins.filtered)

}
