% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_helpers.R
\name{normalize_collection}
\alias{normalize_collection}
\title{Normalize collection table}
\usage{
normalize_collection(
  table,
  normalization,
  lib_sizes = NULL,
  kmer = 1L,
  add_logscore = TRUE,
  split_by_frame = FALSE
)
}
\arguments{
\item{table}{a data.table in long format}

\item{normalization}{a character string, which mode, for options see RiboCrypt:::normalizations}

\item{lib_sizes}{named integer vector, default NULL. If given will do a pre tpm normalization
for full library sizes}

\item{kmer}{integer, default 1L (off), if > 1 will smooth out signal with sliding window size kmer.}

\item{add_logscore}{logical, default TRUE, adds a log(score + 1) to table}

\item{split_by_frame}{logical, default FALSE
For kmer sliding window, should it split by frame}
}
\value{
a data.table of normalized results
}
\description{
Normalize collection table
}
