% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_MAST.R
\name{DA_MAST}
\alias{DA_MAST}
\title{DA_MAST}
\usage{
DA_MAST(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  rescale = c("median", "default"),
  design,
  coefficient = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{rescale}{Rescale count data, per million if 'default', or per median
library size if 'median' ('median' is suggested for metagenomics data).}

\item{design}{The model for the count distribution. Can be the variable name,
or a character similar to "~ 1 + group", or a formula, or a `model.matrix`
object.}

\item{coefficient}{The coefficient of interest as a single word formed by 
the variable name and the non reference level. (e.g.: 'ConditionDisease' if 
the reference level for the variable 'Condition' is 'control').}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`, the matrix
of summary statistics for each tag `statInfo`, and a suggested `name` of the
final object considering the parameters passed to the function.
}
\description{
Fast run for MAST differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 600, size = 3, prob = 0.5), 
                 nrow = 100, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
                         
# Differential abundance
DA_MAST(object = ps, pseudo_count = FALSE, rescale = "median",
    design = ~ group, coefficient = "groupB")
}
\seealso{
\code{\link[MAST]{zlm}} for the Truncated Gaussian Hurdle model
estimation.
}
