% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance.R
\name{createSplits}
\alias{createSplits}
\title{createSplits}
\usage{
createSplits(
  object,
  assay_name = "counts",
  varName = NULL,
  paired = NULL,
  balanced = TRUE,
  N = 1000
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{varName}{name of a factor variable of interest.}

\item{paired}{name of the unique subject identifier variable. If specified,
paired samples will remain in the same split. (default = NULL).}

\item{balanced}{If \code{TRUE} a balanced design will be created for the
splits (default \code{balanced = TRUE}).}

\item{N}{number of splits to generate.}
}
\value{
A list of 2 \code{data.frame} objects: \code{Subset1} and
\code{Subset2} containing \code{N} rows and half of the total number of
samples columns. Each cell contains a unique sample identifier.
}
\description{
Given a phyloseq or TreeSummarizedExperiment object from which the random 
splits should be created, this function produces a list of 2 
\code{data.frame} objects: \code{Subset1} and \code{Subset2} with as many 
rows as the number of splits and as many columns as the half of the number 
of samples.
}
\examples{
data(ps_plaque_16S)
set.seed(123)

# Balanced design for repeated measures

# Balanced design for independent samples
splits_df <- createSplits(
    object = ps_plaque_16S, varName =
        "HMP_BODY_SUBSITE", balanced = TRUE, N = 100
)

# Unbalanced design
splits_df <- createSplits(
    object = ps_plaque_16S, varName =
        "HMP_BODY_SUBSITE", balanced = FALSE, N = 100
)
}
