% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getPositives}
\alias{getPositives}
\title{getPositives}
\usage{
getPositives(method, enrichmentCol, TP, FP)
}
\arguments{
\item{method}{Output of differential abundance detection method in which
DA information is extracted by the \code{getDA} function, information
related to enrichment is appropriately added through the \code{addKnowledge}
function and the Fisher exact tests is performed for the contingency tables
by the \code{enrichmentTests} function.}

\item{enrichmentCol}{name of the column containing information for enrichment
analysis.}

\item{TP}{A list of length-2 vectors. The entries in the vector are the
direction ("UP Abundant", "DOWN Abundant", or "non-DA") in the first
position, and the level of the enrichment variable (\code{enrichmentCol})
which is expected in that direction, in the second position.}

\item{FP}{A list of length-2 vectors. The entries in the vector are the
direction ("UP Abundant", "DOWN Abundant", or "non-DA") in the first
position, and the level of the enrichment variable (\code{enrichmentCol})
which is not expected in that direction, in the second position.}
}
\value{
A named vector containing the number of TPs and FPs.
}
\description{
Inspect the list of p-values or/and log fold changes from the output of a
differential abundance detection method and count the True Positives (TP) and
the False Positives (FP).
}
\examples{
data("ps_plaque_16S")
data("microbial_metabolism")
# Extract genera from the phyloseq tax_table slot
genera <- phyloseq::tax_table(ps_plaque_16S)[, "GENUS"]
# Genera as rownames of microbial_metabolism data.frame
rownames(microbial_metabolism) <- microbial_metabolism$Genus
# Match OTUs to their metabolism
priorInfo <- data.frame(genera,
    "Type" = microbial_metabolism[genera, "Type"]
)
# Unmatched genera becomes "Unknown"
unknown_metabolism <- is.na(priorInfo$Type)
priorInfo[unknown_metabolism, "Type"] <- "Unknown"
priorInfo$Type <- factor(priorInfo$Type)
# Add a more informative names column
priorInfo[, "newNames"] <- paste0(rownames(priorInfo), priorInfo[, "GENUS"])

# DA Analysis
# Add scaling factors
ps_plaque_16S <- norm_edgeR(object = ps_plaque_16S, method = "TMM")
# DA analysis
da.limma <- DA_limma(
    object = ps_plaque_16S,
    design = ~ 1 + HMP_BODY_SUBSITE,
    coef = 2,
    norm = "TMM"
)

DA <- getDA(
    method = da.limma, slot = "pValMat", colName = "adjP",
    type = "pvalue", direction = "logFC", threshold_pvalue = 0.05,
    threshold_logfc = 1, top = NULL
)
# Add a priori information
DA_info <- addKnowledge(
    method = DA, priorKnowledge = priorInfo,
    enrichmentCol = "Type", namesCol = "newNames"
)
# Create contingency tables and compute F tests
DA_info_enriched <- enrichmentTest(
    method = DA_info, enrichmentCol = "Type",
    alternative = "greater"
)
# Count True and False Positives
DA_TP_FP <- getPositives(
    method = DA_info_enriched, enrichmentCol = "Type",
    TP = list(c("UP Abundant", "Aerobic"), c("DOWN Abundant", "Anaerobic")),
    FP = list(c("UP Abundant", "Anaerobic"), c("DOWN Abundant", "Aerobic"))
)
}
\seealso{
\code{\link{createPositives}}.
}
