% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTIEC.R
\name{plotQQ}
\alias{plotQQ}
\title{plotQQ}
\usage{
plotQQ(df_QQ, cols = NULL, zoom = c(0, 0.1), split = FALSE)
}
\arguments{
\item{df_QQ}{Coordinates to draw the QQ-plot to compare the mean observed
p-value distribution across comparisons, with the theoretical uniform
distribution.}

\item{cols}{named vector of colors.}

\item{zoom}{2-dimesional vector containing the starting and the
final coordinates (default: \code{c(0, 0.1)})}

\item{split}{boolean value. If \code{TRUE}, the qq-plots are 
reported separately for each method (default \code{split = FALSE}). Setting 
it to \code{TRUE} is hardly suggested when the number of methods is high or 
when their colors are similar.}
}
\value{
A ggplot object.
}
\description{
Draw the average QQ-plots across the mock comparisons.
}
\examples{
# Load some data
data(ps_stool_16S)

# Generate the patterns for 10 mock comparison for an experiment
# (N = 1000 is suggested)
mocks <- createMocks(nsamples = phyloseq::nsamples(ps_stool_16S), N = 10)
head(mocks)

# Add some normalization/scaling factors to the phyloseq object
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))
ps_stool_16S <- runNormalizations(normalization_list = my_norm,
    object = ps_stool_16S)

# Initialize some limma based methods
my_limma <- set_limma(design = ~ group, coef = 2,
    norm = c("TMM", "CSS"))

# Run methods on mock datasets
results <- runMocks(mocks = mocks, method_list = my_limma,
    object = ps_stool_16S)

# Prepare results for Type I Error Control
TIEC_summary <- createTIEC(results)

# Plot the results
plotFPR(df_FPR = TIEC_summary$df_FPR)
plotFDR(df_FDR = TIEC_summary$df_FDR)
plotQQ(df_QQ = TIEC_summary$df_QQ, zoom = c(0, 0.1))
plotKS(df_KS = TIEC_summary$df_KS)
plotLogP(df_QQ = TIEC_summary$df_QQ)
}
