% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_DESeq2.R
\name{set_DESeq2}
\alias{set_DESeq2}
\title{set_DESeq2}
\usage{
set_DESeq2(
  assay_name = "counts",
  pseudo_count = FALSE,
  design = NULL,
  contrast = NULL,
  alpha = 0.05,
  norm = c("ratio", "poscounts", "iterate"),
  weights_logical = FALSE,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{design}{character or formula to specify the model matrix.}

\item{contrast}{character vector with exactly three elements: the name of a
factor in the design formula, the name of the numerator level for the fold
change, and the name of the denominator level for the fold change.}

\item{alpha}{the significance cutoff used for optimizing the independent
filtering (by default 0.05). If the adjusted p-value cutoff (FDR) will be a
value other than 0.05, alpha should be set to that value.}

\item{norm}{name of the normalization method to use in the differential 
abundance analysis. Choose between the native DESeq2 normalization methods, 
such as \code{ratio}, \code{poscounts}, or \code{iterate}. Alternatively 
(only for advanced users), if \code{norm} is equal to "TMM", "TMMwsp", 
"RLE", "upperquartile", "posupperquartile", or "none" from 
\code{\link{norm_edgeR}}, "CSS" from \code{\link{norm_CSS}}, or "TSS" from 
\code{\link{norm_TSS}}, the normalization factors are automatically 
transformed into size factors. If custom factors are supplied, make sure 
they are compatible with DESeq2 size factors.}

\item{weights_logical}{logical vector, if TRUE a matrix of observational
weights will be used for differential abundance analysis (default
\code{weights_logical = FALSE}).}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_DESeq2}
method.
}
\description{
Set the parameters for DESeq2 differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for DESeq2
base_DESeq2 <- set_DESeq2(design = ~ group, contrast = c("group", "B", "A"))
# Set a specific set of normalization for DESeq2
setNorm_DESeq2 <- set_DESeq2(design = ~ group, contrast =
    c("group", "B", "A"), norm = c("ratio", "poscounts"))
# Set many possible combinations of parameters for DESeq2
all_DESeq2 <- set_DESeq2(pseudo_count = c(TRUE, FALSE), design = ~ group,
    contrast = c("group", "B", "A"), weights_logical = c(TRUE,FALSE))
}
\seealso{
\code{\link{DA_DESeq2}}
}
