% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_dearseq.R
\name{set_dearseq}
\alias{set_dearseq}
\title{set_dearseq}
\usage{
set_dearseq(
  assay_name = "counts",
  pseudo_count = FALSE,
  covariates = NULL,
  variables2test = NULL,
  sample_group = NULL,
  test = c("permutation", "asymptotic"),
  preprocessed = FALSE,
  n_perm = 1000,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{covariates}{a character vector containing the colnames of the 
covariates to include in the model.}

\item{variables2test}{a character vector containing the colnames of the 
variable of interest.}

\item{sample_group}{a vector of length \code{n} indicating whether the samples
should be grouped (e.g. paired samples or longitudinal data). Coerced
to be a \code{factor}. Default is \code{NULL} in which case no grouping is
performed.}

\item{test}{a character string indicating which method to use to approximate 
the variance component score test, either 'permutation' or 'asymptotic'
(default \code{test = "permutation"}).}

\item{preprocessed}{a logical flag indicating whether the expression data have
already been preprocessed (e.g. log2 transformed). Default is \code{FALSE}, in
which case \code{y} is assumed to contain raw counts and is normalized into
log(counts) per million.}

\item{n_perm}{the number of perturbations. Default is \code{1000}}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_dearseq}
method.
}
\description{
Set the parameters for dearseq differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for dearseq 
base_dearseq <- set_dearseq(pseudo_count = FALSE, variables2test = "group",
    test = c("permutation", "asymptotic"), expand = TRUE)
}
\seealso{
\code{\link{DA_dearseq}}
}
