% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/colToRanges.R
\name{colToRanges}
\alias{colToRanges}
\alias{colToRanges,DataFrame-method}
\alias{colToRanges,GRanges-method}
\alias{colToRanges,data.frame-method}
\title{Coerce a column to a GRanges object}
\usage{
colToRanges(x, ...)

\S4method{colToRanges}{DataFrame}(x, var, seqinfo = NULL, ...)

\S4method{colToRanges}{GRanges}(x, var, ..., keep_metadata = TRUE)

\S4method{colToRanges}{data.frame}(x, var, seqinfo = NULL, ...)
}
\arguments{
\item{x}{A data-frame or GRanges object containing the column to coerce}

\item{...}{Used to pass arguments to lower-level functions}

\item{var}{The name of the column to coerce}

\item{seqinfo}{A seqinfo object to be applied to the new GRanges object.
Ignored if the column is already a GRanges object}

\item{keep_metadata}{logical(1) If the original object is a GRanges object,
retain all metadata from the original ranges in the replaced ranges}
}
\value{
A GenomicRanges object
}
\description{
Coerce a column to a GRanges object from a rectangular object
}
\details{
Take a data.frame-like object and coerce one column to a GRanges object,
setting the remainder as the \code{mcols}.
A particularly useful application of this is when you have a GRanges object
with one mcol being a secondary GRanges object.

Alternatively, if you have a data.frame with GRanges represented as a
character column, this provides a simple method of coercion.
In this case, no Seqinfo element will be applied to the GRanges element.
}
\examples{
set.seed(73)
x <- GRanges(c("chr1:1-10", "chr1:6-15", "chr1:51-60"))
seqinfo(x) <- Seqinfo("chr1", 60, FALSE, "Example")
df <- data.frame(logFC = rnorm(3), logCPM = rnorm(3,8), p = 10^-rexp(3))
mcols(x) <- df
gr <- mergeByCol(x, col = "logCPM", pval = "p")
colToRanges(gr, "keyval_range")

}
