% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voomWeightsFromCPM.R
\name{voomWeightsFromCPM}
\alias{voomWeightsFromCPM}
\title{Estimate voom precision weights directly From CPM values}
\usage{
voomWeightsFromCPM(
  cpm,
  design = NULL,
  w0 = NULL,
  lib.size = NULL,
  isLogCPM = TRUE,
  span = 0.5,
  ...
)
}
\arguments{
\item{cpm}{Matrix of CPM or logCPM values}

\item{design}{The design matrix for the experiment}

\item{w0}{Initial vector of sample weights. Should be calculated using
\link[limma]{arrayWeights}}

\item{lib.size}{Initial library sizes. Must be provided as these are no
estimable from CPM values}

\item{isLogCPM}{logical(1). Indicates whether the data is log2 transformed
already. Most commonly (e.g. if using the output of cqn) it will be,}

\item{span}{Width of the smoothing window used for the lowess mean-variance
trend. Expressed as a proportion between 0 and 1.}

\item{...}{Passed to lmFit internally}
}
\value{
An object of class \code{EList} as would be output by voom.
Importantly, there will be no \code{genes} element, although this can be
added later.
Similarly, the returned \code{targets} element will only contain sample
names and library sizes.
This can be incorporated with any other metadata as required.

Plotting data is always returned, noting the the value \code{sx} has
been offset by the library sizes and will be simple logCPM values.
As such, the fitted \code{Amean} is also returned in this list element.

If initial sample weights were provided, modified weights will also be
returned, as the initial function \link[limma]{voomWithQualityWeights}
performs two rounds of estimation of sample weights.
Here we would simply provide the initial weights a priori, with the
second round performed within the function.
Importantly, this second round of sample weight estimation uses the precision
weights ensuring the correct mean-variance relationship is used for the final
estimation of sample weights
}
\description{
Estimate voom precision weights directly From CPM values
}
\details{
This function takes CPM or logCPM values and estimates the precision weights
as would be done by providing counts directly to \link[limma]{voom}.
Using this function enables the use of logCPM values which have been
normalised using other methods such as Conditional-Quantile or
Smooth-Quantile Normalisation.

The precision weights are returned as part of the \code{EList} output, and
these are automatically passed to the function \link[limma]{lmFit}
during model fitting.
This will ensure that the mean-variance relationship is appropriate for
the linear modelling steps as performed by limma.

Initial sample weights can be passed to the function, and should be
calculated using \link[limma]{arrayWeights} called on the normalised logCPM
values.
The returned sample weights will be different to these, given that the
function \link[limma]{voomWithQualityWeights} performs two rounds of
estimation.
The first is on the initial data, with the inappropriate mean-variance
relationship, whilst the second round is after incorporation of the precision
weights.
}
\examples{
library(csaw)
library(edgeR)
bamFiles <- system.file("exdata", c("rep1.bam", "rep2.bam"), package="csaw")
wc <- windowCounts(bamFiles, filter=1)
cpm <- cpm(wc, log = TRUE)
el <- voomWeightsFromCPM(cpm, lib.size = wc$totals)

}
