% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{estimate_idr}
\alias{estimate_idr}
\title{Estimates IDR for Genomic Peaks or Genomic Interactions}
\usage{
estimate_idr(
  rep1_df,
  rep2_df,
  analysis_type = "IDR2D",
  value_transformation = c("identity", "additive_inverse", "multiplicative_inverse",
    "log", "log_additive_inverse"),
  ambiguity_resolution_method = c("overlap", "midpoint", "value"),
  remove_nonstandard_chromosomes = TRUE,
  max_factor = 1.5,
  jitter_factor = 1e-04,
  max_gap = -1L,
  mu = 0.1,
  sigma = 1,
  rho = 0.2,
  p = 0.5,
  eps = 0.001,
  max_iteration = 30,
  local_idr = TRUE
)
}
\arguments{
\item{rep1_df}{data frame of observations (i.e., genomic peaks or genomic
interactions) of
replicate 1. If \code{analysis_type} is IDR1D, the columns of \code{rep1_df}
are described in \code{\link{establish_bijection1d}}, otherwise in
\code{\link{establish_bijection2d}}}

\item{rep2_df}{data frame of observations (i.e., genomic peaks or genomic
interactions) of replicate 2. Same columns as \code{rep1_df}.}

\item{analysis_type}{"IDR2D" for genomic interaction data sets,
"IDR1D" for genomic peak data sets}

\item{value_transformation}{the values in \code{x} have to be transformed in
a way such that when ordered in descending order, more significant
interactions end up on top of the list. If the values in \code{x} are
p-values, \code{"log_additive_inverse"} is recommended. The following
transformations are supported:
\tabular{rl}{
  \code{"identity"} \tab no transformation is performed on \code{x}\cr
  \code{"additive_inverse"} \tab \code{x. = -x}\cr
  \code{"multiplicative_inverse"} \tab \code{x. = 1 / x}\cr
  \code{"log"} \tab \code{x. = log(x)}. Note: zeros are replaced by
  \code{.Machine$double.xmin}\cr
  \code{"log_additive_inverse"} \tab \code{x. = -log(x)}, recommended if
  \code{x} are p-values. Note: zeros are replaced by
  \code{.Machine$double.xmin}
}

either \code{"ascending"} (more significant
interactions have lower value in \code{value} column) or \code{"descending"}
(more significant interactions have higher value in \code{value} column)}

\item{ambiguity_resolution_method}{defines how ambiguous assignments
(when one interaction or peak in replicate 1 overlaps with
multiple interactions or peaks in replicate 2 or vice versa)
are resolved. For available methods, see \code{\link{establish_overlap1d}} or
\code{\link{establish_overlap2d}}, respectively.}

\item{remove_nonstandard_chromosomes}{removes peaks and interactions
containing
genomic locations on non-standard chromosomes using
\code{\link[GenomeInfoDb:seqlevels-wrappers]{keepStandardChromosomes}}
(default is TRUE)}

\item{max_factor}{numeric; controls the replacement values for \code{Inf}
and \code{-Inf}. \code{Inf} are replaced by \code{max(x) * max_factor} and
\code{-Inf} are replaced by \code{min(x) / max_factor}.}

\item{jitter_factor}{numeric; controls the magnitude of the noise that
is added to \code{x}. This is done to break ties in \code{x}. Set
\code{jitter_factor = NULL} for no jitter.}

\item{max_gap}{integer; maximum gap in nucleotides allowed between two
anchors for them to be considered as overlapping
(defaults to -1, i.e., overlapping anchors)}

\item{mu}{ a starting value for the mean of the reproducible component.}

\item{sigma}{ a starting value for the standard deviation of the
    reproducible component.}

\item{rho}{ a starting value for the correlation coefficient of the
    reproducible component.}

\item{p}{ a starting value for the proportion of reproducible component.}

\item{eps}{ Stopping criterion. Iterations stop when the increment of
    log-likelihood is < eps*log-likelihood, Default=0.001.}

\item{max_iteration}{integer; maximum number of iterations for
IDR estimation (defaults to 30)}

\item{local_idr}{see \code{\link[idr:est.IDR]{est.IDR}}}
}
\value{
See \code{\link{estimate_idr1d}} or
\code{\link{estimate_idr2d}}, respectively.
}
\description{
Estimates IDR for Genomic Peaks or Genomic Interactions
}
\examples{
idr_results <- estimate_idr(idr2d:::chiapet$rep1_df,
                            idr2d:::chiapet$rep2_df,
                            analysis_type = "IDR2D",
                            value_transformation = "log_additive_inverse")
summary(idr_results)

}
\references{
Q. Li, J. B. Brown, H. Huang and P. J. Bickel. (2011) Measuring
reproducibility of high-throughput experiments. Annals of Applied
Statistics, Vol. 5, No. 3, 1752-1779.
}
