% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFND_queries.R
\name{query_haplotype_frequencies}
\alias{query_haplotype_frequencies}
\title{Query haplotype frequencies}
\usage{
query_haplotype_frequencies(
  hla_selection = NA,
  hla_population = NA,
  hla_country = NA,
  hla_region = NA,
  hla_ethnic = NA,
  hla_sample_size_pattern = NA,
  hla_sample_size = NA
)
}
\arguments{
\item{hla_selection}{Alleles that will be used to build the haplotype query. 
One entry per locus. If no entry for a given locus, the function will search 
for haplotypes that do not include specifications for this locus. If any 
allele for a given locus should be considered, the list entry should be 
"A*" or other locus in same format.}

\item{hla_population}{Numeric identifier of the population that will be used 
for filtering. Thie identifier is defined by the Allele Frequency Net 
Database.}

\item{hla_country}{Country of interest (e.g. Germany, France, ...).}

\item{hla_region}{Geographic region of interest (e.g. Europe, 
North Africa, ...)}

\item{hla_ethnic}{Ethnic origin of interest (e.g. Caucasoid, Siberian, ...)}

\item{hla_sample_size_pattern}{Keyword used to define the filtering for a 
specific population size. e.g. "bigger_than", "equal", "less_than", 
"less_equal_than", "bigger_equal_than"}

\item{hla_sample_size}{Integer number used to define the filtering for a 
specific population size, together with the hla_sample_size_pattern argument.}
}
\value{
data.frame object containing the result of the allele frequency query
}
\description{
Query haplotype frequencies
}
\examples{
# works only for one haplotype at a time
query_haplotype_frequencies(hla_selection = c("A*02:01", "B*", "C*"), 
hla_region = "Europe")

}
