% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpScorePlot.R
\name{lmpScorePlot}
\alias{lmpScorePlot}
\title{Score plots of effect matrices}
\usage{
lmpScorePlot(resLmpPcaEffects, effectNames = NULL, axes = c(1, 2), ...)
}
\arguments{
\item{resLmpPcaEffects}{A list corresponding to the output value of \code{\link{lmpPcaEffects}}.}

\item{effectNames}{Names of the effects to be plotted. If \code{NULL}, all the effects are plotted.}

\item{axes}{A numerical vector with the 2 Principal Components axes to be drawn.}

\item{...}{Additional arguments to be passed to \code{\link{plotScatter}}.}
}
\value{
A list of score plots (ggplot).
}
\description{
Draws the score plots of each (augmented) effect matrix provided in \code{\link{lmpPcaEffects}}. As a wrapper of the \code{\link{plotScatter}} function, it allows to visualize the scores of the effect matrices for two components at a time with all the available options in  \code{\link{plotScatter}}.
}
\details{
\code{lmpScorePlot} is a wrapper of \code{\link{plotScatter}}.
}
\examples{

data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)

# PCA decomposition of effect matrices (ASCA)
resASCA <- lmpPcaEffects(resLmpEffectMatrices)
# Score plot of Hippurate effect matrix
lmpScorePlot(resASCA,
  effectNames = "Hippurate",
  color = "Hippurate", shape = "Hippurate"
)

# PCA decomposition of augmented effect matrices (APCA)
resASCA <- lmpPcaEffects(resLmpEffectMatrices, method = "APCA")
# Score plot of Hippurate augmented effect matrix
lmpScorePlot(resASCA,
  effectNames = "Hippurate",
  color = "Hippurate", shape = "Hippurate", drawShapes = "ellipse"
)
}
