% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCluster.R
\name{runKMeans}
\alias{runKMeans}
\title{Get clustering with KMeans}
\usage{
runKMeans(
  inSCE,
  nCenters,
  useReducedDim = "PCA",
  clusterName = "KMeans_cluster",
  nComp = 10,
  nIter = 10,
  nStart = 1,
  seed = 12345,
  algorithm = c("Hartigan-Wong", "Lloyd", "MacQueen")
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object.}

\item{nCenters}{An \code{integer}, the number of centroids (clusters).}

\item{useReducedDim}{A single \code{character}, specifying which
low-dimension representation to perform the clustering algorithm on. Default
\code{"PCA"}.}

\item{clusterName}{A single \code{character}, specifying the name to store
the cluster label in \code{\link{colData}}. Default \code{"KMeans_cluster"}.}

\item{nComp}{An \code{integer}. The number of components to use for K-Means.
Default \code{10}. See Detail.}

\item{nIter}{An \code{integer}, the maximum number of iterations allowed.
Default \code{10}.}

\item{nStart}{An \code{integer}, the number of random sets to choose. Default
\code{1}.}

\item{seed}{An \code{integer}. The seed for the random number generator.
Default \code{12345}.}

\item{algorithm}{A single \code{character}. Choose from
\code{"Hartigan-Wong"}, \code{"Lloyd"}, \code{"MacQueen"}. May be
abbreviated. Default \code{"Hartigan-Wong"}.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{factor} cluster labeling updated in
\code{colData(inSCE)[[clusterName]]}.
}
\description{
Perform KMeans clustering on a
\linkS4class{SingleCellExperiment} object, with \code{\link[stats]{kmeans}}.
}
\examples{
data("mouseBrainSubsetSCE")
mouseBrainSubsetSCE <- runKMeans(mouseBrainSubsetSCE,
                                 useReducedDim = "PCA_logcounts",
                                 nCenters = 2)
}
