% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrublet_doubletDetection.R
\name{runScrublet}
\alias{runScrublet}
\title{Find doublets using \code{scrublet}.}
\usage{
runScrublet(
  inSCE,
  sample = NULL,
  useAssay = "counts",
  simDoubletRatio = 2,
  nNeighbors = NULL,
  minDist = NULL,
  expectedDoubletRate = 0.1,
  stdevDoubletRate = 0.02,
  syntheticDoubletUmiSubsampling = 1,
  useApproxNeighbors = TRUE,
  distanceMetric = "euclidean",
  getDoubletNeighborParents = FALSE,
  minCounts = 3,
  minCells = 3L,
  minGeneVariabilityPctl = 85,
  logTransform = FALSE,
  meanCenter = TRUE,
  normalizeVariance = TRUE,
  nPrinComps = 30L,
  tsneAngle = NULL,
  tsnePerplexity = NULL,
  verbose = TRUE,
  seed = 12345
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object.}

\item{sample}{Character vector or colData variable name. Indicates which 
sample each cell belongs to. Default \code{NULL}.}

\item{useAssay}{A string specifying which assay in the SCE to use. Default 
\code{"counts"}.}

\item{simDoubletRatio}{Numeric. Number of doublets to simulate relative to
the number of observed transcriptomes. Default \code{2.0}.}

\item{nNeighbors}{Integer. Number of neighbors used to construct the KNN
graph of observed transcriptomes and simulated doublets. If \code{NULL},
this is set to \code{round(0.5 * sqrt(n_cells))}. Default \code{NULL}.}

\item{minDist}{Float Determines how tightly UMAP packs points together. If 
\code{NULL}, this is set to \code{0.1}. Default \code{NULL}.}

\item{expectedDoubletRate}{The estimated doublet rate for the experiment.
Default \code{0.1}.}

\item{stdevDoubletRate}{Uncertainty in the expected doublet rate. Default 
\code{0.02}.}

\item{syntheticDoubletUmiSubsampling}{Numeric. Rate for sampling UMIs when
creating synthetic doublets. If \code{1.0}, each doublet is created by simply
adding the UMIs from two randomly sampled observed transcriptomes. For
values less than 1, the UMI counts are added and then randomly sampled at
the specified rate. Defuault \code{1.0}.}

\item{useApproxNeighbors}{Boolean. Use approximate nearest neighbor method
(annoy) for the KNN classifier. Default \code{TRUE}.}

\item{distanceMetric}{Character. Distance metric used when finding nearest
neighbors. See detail. Default \code{"euclidean"}.}

\item{getDoubletNeighborParents}{Boolean. If \code{TRUE}, return the
parent transcriptomes that generated the doublet neighbors of each
observed transcriptome. This information can be used to infer the cell states
that generated a given doublet state. Default \code{FALSE}.}

\item{minCounts}{Numeric. Used for gene filtering prior to PCA. Genes
expressed at fewer than \code{minCounts} in fewer than \code{minCells} are
excluded. Default \code{3}.}

\item{minCells}{Integer. Used for gene filtering prior to PCA. Genes
expressed at fewer than \code{minCounts} in fewer than \code{minCells} are 
excluded. Default \code{3}.}

\item{minGeneVariabilityPctl}{Numeric. Used for gene filtering prior to
PCA. Keep the most highly variable genes (in the top
\code{minGeneVariabilityPctl} percentile), as measured by the v-statistic
(Klein et al., Cell 2015). Default \code{85}.}

\item{logTransform}{Boolean. If \code{TRUE}, log-transform the counts matrix
(log1p(TPM)). \code{sklearn.decomposition.TruncatedSVD} will be used for
dimensionality reduction, unless \code{meanCenter} is \code{TRUE}. Default 
\code{FALSE}.}

\item{meanCenter}{If \code{TRUE}, center the data such that each gene has a
mean of \code{0}. \code{sklearn.decomposition.PCA} will be used for
dimensionality reduction. Default \code{TRUE}.}

\item{normalizeVariance}{Boolean. If \code{TRUE}, normalize the data such
that each gene has a variance of 1.
\code{sklearn.decomposition.TruncatedSVD} will be used for dimensionality
reduction, unless \code{meanCenter} is \code{TRUE}. Default \code{TRUE}.}

\item{nPrinComps}{Integer. Number of principal components used to embed
the transcriptomes prior to k-nearest-neighbor graph construction.
Default \code{30}.}

\item{tsneAngle}{Float. Determines angular size of a distant node as measured
from a point in the t-SNE plot. If \code{NULL}, it is set to \code{0.5}. 
Default \code{NULL}.}

\item{tsnePerplexity}{Integer. The number of nearest neighbors that is used
in other manifold learning algorithms. If \code{NULL}, it is set to 30. 
Default \code{NULL}.}

\item{verbose}{Boolean. If \code{TRUE}, print progress updates. Default
\code{TRUE}.}

\item{seed}{Seed for the random number generator, can be set to \code{NULL}. 
Default \code{12345}.}
}
\value{
A \linkS4class{SingleCellExperiment} object with
\code{scrub_doublets} output appended to the \link{colData} slot. The columns
include \code{scrublet_score} and \code{scrublet_call}.
}
\description{
A wrapper function that calls \code{scrub_doublets} from python
 module \code{scrublet}. Simulates doublets from the observed data and uses
 a k-nearest-neighbor classifier to calculate a continuous
 \code{scrublet_score} (between 0 and 1) for each transcriptome. The score
 is automatically thresholded to generate \code{scrublet_call}, a boolean
 array that is \code{TRUE} for predicted doublets and \code{FALSE}
 otherwise.
}
\details{
For the list of valid values for \code{distanceMetric}, see the 
documentation for 
\href{https://github.com/spotify/annoy#full-python-api}{annoy} (if 
\code{useApproxNeighbors} is \code{TRUE}) or 
\href{https://scikit-learn.org/stable/modules/generated/sklearn.neighbors.NearestNeighbors.html}{sklearn.neighbors.NearestNeighbors}
(if \code{useApproxNeighbors} is  \code{FALSE}).
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runScrublet(sce)
}
}
\seealso{
\code{\link{plotScrubletResults}}, \code{\link{runCellQC}}
}
