% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix-based.R
\name{score_transcripts_single_motif}
\alias{score_transcripts_single_motif}
\title{Scores transadsadscripts with position weight matrices}
\usage{
score_transcripts_single_motif(
  motif,
  sequences,
  max_hits = 5,
  threshold_method = c("p_value", "relative"),
  threshold_value = 0.25^6,
  cache_path = paste0(tempdir(), "/sc/")
)
}
\arguments{
\item{motif}{a Transite motif that is used to score the specified sequences}

\item{sequences}{character vector of named sequences
(only containing upper case characters A, C, G, T), where the names are
RefSeq identifiers
and sequence
type qualifiers (\code{"3UTR"}, \code{"5UTR"}, \code{"mRNA"}), e.g.
\code{"NM_010356|3UTR"}}

\item{max_hits}{maximum number of putative binding sites per mRNA
that are counted}

\item{threshold_method}{either \code{"p_value"} (default) or
\code{"relative"}.
If \code{threshold_method} equals \code{"p_value"}, the default
\code{threshold_value}
 is \code{0.25^6}, which is
lowest p-value that can be achieved by hexamer motifs, the shortest
supported motifs.
If \code{threshold_method} equals \code{"relative"}, the default
\code{threshold_value}
is \code{0.9}, which is 90\% of the maximum PWM score.}

\item{threshold_value}{semantics of the \code{threshold_value} depend on
\code{threshold_method} (default is 0.25^6)}

\item{cache_path}{the path to a directory where scores are cached.
The scores of each
motif are stored in a
separate file that contains a hash table with RefSeq identifiers
and sequence type
qualifiers as keys and the number of binding sites as values.
If is.null(cache_path), scores will not be cached.}
}
\value{
A list with the following items:
\tabular{rl}{
  \code{motif_id} \tab the motif identifier of the specified motif\cr
  \code{motif_rbps} \tab the gene symbol of the RNA-binding protein(s)\cr
  \code{absolute_hits} \tab the absolute frequency of binding sites per
  motif in all
  transcripts \cr
  \code{relative_hits} \tab  the relative, i.e., absolute divided by
  total, frequency of
  binding sites per motif in all transcripts \cr
  \code{total_sites} \tab the total number of potential binding sites \cr
  \code{one_hit}, \code{two_hits}, ... \tab number of transcripts with
  one, two, three,
  ... binding sites
}
}
\description{
This function is used to count the putative binding sites (i.e., motifs)
in a set of
sequences for the specified RNA-binding protein sequence
motifs and returns the result in a data frame, which is aggregated by
\code{\link{score_transcripts}} and
subsequently used by \code{\link{calculate_motif_enrichment}} to
obtain binding site enrichment scores.
}
\seealso{
Other matrix functions: 
\code{\link{calculate_motif_enrichment}()},
\code{\link{run_matrix_spma}()},
\code{\link{run_matrix_tsma}()},
\code{\link{score_transcripts}()}
}
\concept{matrix functions}
